### **实验名称**

分类算法的应用案例：酒品质分类

### **实验目的**

1.  掌握数据预处理的方法，包括数据清洗、数据标准化等
    
2.  熟悉常用分类算法（KNN、贝叶斯等）并能在实际数据中应用
    
3.  学会模型评估和比较，理解混淆矩阵、准确率、精确率、召回率和F1分数等评价指标
    
4.  能够通过实验结果进行分析和总结，提出模型改进建议
    

### **实验背景**

葡萄酒质量的评估是葡萄酒生产过程中至关重要的环节，它不仅影响消费者的选择，还对葡萄酒的市场表现有直接的影响。在葡萄酒的质量评估过程中，通常依赖于经验丰富的品酒师进行感官评价。然而，这种方法主观性较强，且在不同品酒师之间可能存在较大差异。因此，开发基于理化指标的自动化质量预测模型，能够为葡萄酒行业提供一种客观、快速且一致的质量评估手段。

本实验使用的数据集来自葡萄牙北部著名的“Vinho Verde”葡萄酒产区。由于隐私和物流的限制，数据集中仅包含葡萄酒的理化性质变量，例如酒精含量、pH值、总酸度等。这些理化特征可以在一定程度上反映出葡萄酒的品质，因而成为本实验中用于预测葡萄酒质量的核心变量。

本实验的目标是利用分类算法，根据这些理化特征来预测葡萄酒的质量等级。通过训练和评估不同的分类模型，找出最优的模型及其参数设置，以期能够准确、有效地预测葡萄酒的质量。这一研究不仅有助于推动葡萄酒质量评价的自动化，还为相关领域的研究人员提供了宝贵的数据和方法参考。

### **实验原理**

#### 1\. KNN算法的原理

KNN算法（K-Nearest Neighbors, KNN）是一种基本且常用的分类算法。其原理简单且直观，主要基于“**物以类聚**”这一假设：一个样本的类别或数值很大程度上取决于其最接近的样本。

![01-knn.png](./pic/01-knn.png)

KNN算法的工作原理和步骤如下。

(1)**数据准备**：

*   首先，收集好训练数据集，这些数据集中的样本已经标注了类别（用于分类）。
    

(2)**距离计算**：

*   对于一个待分类的样本，计算它与训练数据集中所有样本的距离。常用的距离计算方法是欧几里得距离，也可以使用曼哈顿距离、余弦相似度等。
    
*   假设样本 A(x1,x2,...,xn) 和样本 B(y1,y2,...,yn) 在n维空间中的坐标分别为 (x1,x2,...,xn) 和 (y1,y2,...,yn)，它们的欧几里得距离为：
    
    ![02-欧几里得公式.png](./pic/02-欧几里得公式.png)
    

(3)**选择K个最近邻**：

*   选择离待分类样本最近的K个样本。具体的K值通常需要通过交叉验证等方法进行选择。
    

(4)**分类**：

*   对这K个样本的类别进行统计，选择出现频率最高的类别作为待分类样本的预测类别。
    

(5)**结果输出**：

*   最终输出待分类样本的预测类别。
    

**KNN的优缺点：**

**优点**：

*   简单易理解，直观有效。
    
*   无需假设数据的分布，属于非参数模型。
    
*   对于一些高维特征的分类任务，KNN也可以取得不错的效果。
    

**缺点**：

*   计算开销较大，尤其是在大规模数据集上，因为需要计算待分类样本与所有训练样本的距离。
    
*   存储开销较大，因为需要保存全部的训练样本。
    
*   对噪声敏感，特别是K值较小时，噪声样本可能会对结果造成较大影响。
    
*   K值的选择较为关键，K值太小容易过拟合，K值太大容易欠拟合。
    

KNN虽然简单，但在实际应用中仍然十分有效，尤其是当数据集较小且特征较为明显时，KNN常常能提供不错的分类或回归结果。

#### 2\. 朴素贝叶斯算法的原理

朴素贝叶斯（Naive Bayes）是一类基于贝叶斯定理的简单而高效的分类算法，特别适合于文本分类等高维数据的场景。尽管其假设“朴素”（即特征之间是条件独立的），但在实际应用中常常表现出较好的性能。

（1）**贝叶斯定理**：

*   朴素贝叶斯算法基于贝叶斯定理来进行分类。贝叶斯定理表明：
    
    P(C∣X)=P(X∣C)⋅P(C)/P(X)
    
    其中：
    
    *   P(C∣X) 是在已知特征 X的条件下，样本属于类别 C的概率（后验概率）。
        
    *   P(X∣C)是在类别 C 下，观测到特征 X 的概率。
        
    *   P(C) 是类别 C 的先验概率，即在没有考虑特征 XX的情况下，类别 C的概率。
        
    *   P(X)是观测到特征 X的概率，是一个常数，用于规范化。
        

（2）**朴素假设**：

*   朴素贝叶斯假设特征之间是条件独立的，即对于给定的类别 C，每个特征 Xi 的发生概率是独立的。因此，联合概率 P(X∣C) 可以表示为各个特征条件概率的乘积： P(X∣C)=P(x1,x2,...,xn∣C)=P(x1∣C)⋅P(x2∣C)⋅...⋅P(xn∣C)
    
*   在实际应用中，这一假设虽然不一定严格成立，但往往能简化计算，并取得良好的分类效果。
    

（3）**分类决策**：

*   根据贝叶斯定理，朴素贝叶斯分类器通过计算样本属于每个类别的后验概率P(C∣X)，将样本归类到后验概率最大的类别。
    

（4）**模型训练**：

*   计算每个类别 C 的先验概率 P(C)：
    
    P(C)=类别 C 中的样本数 / 总样本数
    
*   计算每个特征在给定类别下的条件概率 P(xi∣C)
    
    具体的计算方式取决于特征的类型：
    
    *   **对于离散型特征**，使用频率估计。
        
    *   **对于连续型特征**，通常假设其服从正态分布，通过计算均值和方差来得到条件概率。
        

（5）**预测**：

*   对于一个新的样本，计算该样本属于每个类别的后验概率，将样本归类到后验概率最大的类别。
    

**朴素贝叶斯的优缺点：**

**优点**：

*   算法简单，计算效率高，特别适合大规模数据集。
    
*   对小规模的数据和多分类问题表现良好。
    
*   对高维数据表现较好，常用于文本分类、垃圾邮件过滤等领域。
    
*   对缺失数据和噪声不敏感。
    

**缺点**：

*   朴素假设过于简单，特征之间的独立性假设在实际问题中不总是成立，当特征之间强相关时，分类性能可能受到影响。
    
*   当特征条件概率非常小或为零时，会导致计算结果为零，这可以通过平滑技术（如拉普拉斯平滑）来解决。
    

尽管朴素贝叶斯算法存在一些局限性，但由于其高效性和鲁棒性，依然是许多实际应用中非常重要的分类方法。

### **实验环境**

Ubuntu 18.04

scikit-learn 1.4.1

python 3.9

jupyter notebook 1.0.0

pandas 2.0.3

### 建议课时

2课时

### 实验步骤

#### 1.下载数据集：

双击打开桌面的“terminal”后，在命令行中输入如下命令，下载数据集

```markup
cd ~
wget http://10.90.3.2/HUP/DataMining/2024/05/WineData.zip
unzip -o WineData.zip -d /home/ubuntu/
```

2.开启 jupyter notebook：

在终端输入命令

```markup
jupyter notebook
```

![00-终端.png](./pic/00-终端.png)

打开 Jupyter，点击右上角上的“New”按钮，选择“python3”创建文件。

![1721522453348.png](./pic/1721522453348.png)

#### 3.查看数据

该数据集包含四个文件

*   winequality-red.csv：红葡萄酒质量数据
    
*   winequality-white.csv：白葡萄酒质量数据
    
*   white\_train.csv：白葡萄酒质量训练集数据（target label: good\_or\_not, 即quality>5的样本都为品质好的葡萄酒）
    
*   white\_test.csv：白葡萄酒质量测试集数据（without target label）
    

下面以winequality-red.csv（红葡萄酒质量数据）为例说明：

*   数据集的整体特征
    

| 数据集名称 | 数据类型 | 特征数 | 实例数 | 值缺失 |
| --- | --- | --- | --- | --- |
| 红葡萄酒质量 | 数值数据 | 12 | 1599 | 无 |

*   属性描述 **文件winequality-red.csv包含12个字段，具体信息如下：** 每一行代表的是一种红葡萄酒
    

| No | 属性 | 数据类型 | 字段描述 |
| --- | --- | --- | --- |
| 1 | fixed acidity | Numeric | 非挥发性酸 |
| 2 | volatile acidity | Numeric | 挥发性酸 |
| 3 | citric acid | Numeric | 柠檬酸 |
| 4 | residual sugar | Numeric | 残糖 |
| 5 | chlorides | Numeric | 氯化物 |
| 6 | free sulfur dioxide | Numeric | 游离二氧化硫 |
| 7 | total sulfur dioxide | Numeric | 总二氧化硫 |
| 8 | density | Numeric | 密度 |
| 9 | pH | Numeric | 酸碱度 |
| 10 | sulphates | Numeric | 硫酸盐 |
| 11 | alcohol | Numeric | 酒精 |
| 12 | quality (1-10) | Numeric | 葡萄酒质量（1-10之间） |

```python
# 加载数据
import pandas as pd
import numpy as np
df = pd.read_csv("/home/ubuntu/winequality-red.csv")
df.head()
```

![02-实验步骤1.png](./pic/02-实验步骤1.png)

```markup
#查看数据集行列数
print("该数据集共有 {} 行 {} 列".format(df.shape[0],df.shape[1]))
```

该数据集共有 1599 行 12 列

```python
#查看特征和空值
print("查看空值：")
df.isnull().any()
```

![02-实验步骤2.png](./pic/02-实验步骤2.png)

```python
# 查看葡萄酒质量情况分布
score = df.groupby("quality").agg({"fixed acidity": lambda x: len(x)})
score = score.reset_index()
score.columns = ["quality","count"]
score
```

![02-实验步骤3.png](./pic/02-实验步骤3.png)

```python
import matplotlib.pyplot as plt
import seaborn as sns

plt.rcParams['font.sans-serif'] = ['Microsoft YaHei']

# 假设 'quality' 列表示分类标签
sns.barplot(x='quality', y='count', data=score, hue='quality', palette="rocket", legend=False).set_title("葡萄酒质量分布")

plt.show()
```

![02-实验步骤4.png](./pic/02-实验步骤4.png)

#### 4.高质量红酒的定义

我们将评分为6分及以上的红酒定义为高质量红酒。

本研究的目的是建立分类模型，区分“高质量红酒”与非“高质量红酒”，是一个**二元分类**问题。

```python
df["GoodWine"] = df.quality.apply(lambda x: 1 if x >=6 else 0)
```

#### 5.将数据集分为训练集和测试集

我们有1599行数据，按照70%和30%将数据集分为training set和test set

```python
from sklearn.model_selection import train_test_split
# random_state参数：设定随机种子，设定后结果固定（若不设定，每次执行后的数据集划分都不一样）
X_train, X_test, y_train, y_test = train_test_split(df.drop(columns=["GoodWine","quality"]),df["GoodWine"],test_size = 0.3,random_state=0)
X_train
```

#### 6.数据归一化(Normalisation)

```python
from sklearn.preprocessing import StandardScaler
scaler = StandardScaler().fit(X_train)
X_train = scaler.transform(X_train)
X_test = scaler.transform(X_test)
```

#### 7.训练KNN分类器

KNN算法主要考虑的重要要素：

*   K值的选择
    
*   距离度量的方式
    

在这里，我们先给k值选择一个较小的值，然后通过交叉验证选择一个合适k值。

假定k = 3，建立一个KNN分类器，并查看其准确率。

```python
from sklearn.neighbors import KNeighborsClassifier
#初始化
k = 3
clf = KNeighborsClassifier(k)
#使用training set训练模型
clf.fit(X_train, y_train)
# training set正确率
print("训练集正确率：{}%".format(round(clf.score(X_train, y_train)*100,2)))
```

训练集正确率：86.77%

```markup
# 5折交叉验证
# cross validation正确率
from sklearn.model_selection import cross_val_score
scores = cross_val_score(clf, X_train, y_train, cv = 5)
score = scores.mean()
print("交叉验证正确率：{}%".format(round(score*100, 2)))
```

交叉验证正确率：72.74%

#### 8.选择最优的K值

我们使用交叉验证(cross validation)选择最好的k，使得KNN分类器在未来的数据上有最好的表现。

这里尝试k = 1,2,3,...100。

```python
# selecting the best k
ks = range(1,101)
inSampleScores = []
crossValidationScores = []
d = {} #key = k, value = cv accuracy rate

for k in ks:
    clf = KNeighborsClassifier(k).fit(X_train, y_train)
    inSampleScores.append(clf.score(X_train, y_train))
    scores = cross_val_score(clf, X_train, y_train, cv = 5)
    crossValidationScores.append(scores.mean())
    d[k] = scores.mean()
# 画图
import matplotlib.pyplot as plt

p1 = plt.plot(ks, inSampleScores)
p2 = plt.plot(ks, crossValidationScores)
plt.legend(["train正确率", "cv正确率"])
plt.show()
```

![02-实验步骤5.png](./pic/02-实验步骤5.png)

```python
# 选择最好的k
best_k = sorted(d.items(), key = lambda x:x[1], reverse = True)[0][0]
print("最优的k值：{}".format(best_k))
```

最优的k值：72

#### 9.将最好的KNN分类器应用于test set上

```python
#建模
clf = KNeighborsClassifier(best_k).fit(X_train, y_train)

#预测
y_test_pred = clf.predict(X_test)

#正确率
print("测试集正确率：{}%".format(round(clf.score(X_test, y_test)*100, 2)))
```

测试集正确率：72.71%

```python
# 混淆矩阵 (confusion matrix)
from sklearn.metrics import confusion_matrix,ConfusionMatrixDisplay
cnf_matrix = confusion_matrix(y_test, y_test_pred)

cmd = ConfusionMatrixDisplay(confusion_matrix= cnf_matrix)
cmd.plot()
```

![02-实验步骤6.png](./pic/02-实验步骤6.png)

```python
# 其它评估指标
from sklearn.metrics import classification_report
class_report_knn = classification_report(y_test, y_test_pred)
print(class_report_knn)
```

![image_course_1657_user_3961_assignment_20192_1724291986586.png](./pic/image_course_1657_user_3961_assignment_20192_1724291986586.png)

**KNN模型评分如下:**

**1.精确度: 对于类别0，精确度为0.73，对于类别1，精确度为0.72。**

**2.召回率: 对于类别0，召回率为0.66，对于类别1，召回率为0.79。**

**3.准确率: 0.73**

#### 10\. 使用贝叶斯算法进行分类

```python
from sklearn.naive_bayes import GaussianNB
gnb = GaussianNB()
gnb.fit(X_train,y_train)
#朴素贝叶斯的评估指标
y_pred_gnb = gnb.predict(X_test)
class_report_gnb = classification_report(y_test, y_pred_gnb)
print(class_report_gnb)
```

**![image_course_1657_user_3961_assignment_20192_1724291695949.png](./pic/image_course_1657_user_3961_assignment_20192_1724291695949.png)**

**贝叶斯模型评分如下:**

**1.精确度: 对于类别0，精确度为0.72，对于类别1，精确度为0.74。**

**2.召回率: 对于类别0，召回率为0.70，对于类别1，召回率为0.75。**

**3.准确率: 0.73**

```python
# 混淆矩阵
cnf_matrix_gnb = confusion_matrix(y_test, y_pred_gnb)
cmd_gnb = ConfusionMatrixDisplay(confusion_matrix= cnf_matrix_gnb)
cmd_gnb.plot()
```

![02-实验步骤9.png](./pic/02-实验步骤9.png)

#### 11\. KNN与贝叶斯评估对比

<table style="border-collapse: collapse; width: 100%;" border="1"><tbody><tr><td style="width: 25%;">算法</td><td style="width: 25%;">准确率</td><td style="width: 25%;">精确度</td><td style="width: 25%;">召回率</td></tr><tr><td style="width: 25%;">KNN</td><td style="width: 25%;">0.73</td><td style="width: 25%;">0.73，0.72</td><td style="width: 25%;">0.66，0.79</td></tr><tr><td style="width: 25%;">贝叶斯</td><td style="width: 25%;">0.73</td><td style="width: 25%;">0.72，0.74</td><td style="width: 25%;">0.70，0.75</td></tr></tbody></table>

对比两个模型的准确率、精确度、召回率，评估值都基本相等，所以对于本项目的数据，选择任一的模型结果相似。但考虑到KNN比较适用与中小数据，若数据更多的情况下建议使用贝叶斯。

### **实验总结**

通过对KNN和朴素贝叶斯算法的介绍，从而对分类算法的应用有更深的了解。在实际应用上，可以先建立多个模型，通过对比模型的评估值（例如准确率、精确度、召回率等），选择更适合的模型以达到整体效果的提升。模型的优化上，基于KNN算法的模型可以通过选择合适的K值进行调优。